/*
 * Copyright (c) 2008, PRODYNA AG, Germany. All rights reserved. Created 10.01.2008
 */

package classcastexceptiontest.processinvoker;

import org.apache.log4j.Logger;

/**
 * ProcessInvokerWorker
 * 
 * @author Andreas Heizenreder (PRODYNA AG)
 * @version $Id: ProcessInvokerWorker.java,v 1.1 2008/08/22 15:27:08 aheizenreder Exp $
 */
public class ProcessInvokerWorker implements Runnable {

    private ProcessInvokerTest processInvokerTest;

    public ProcessInvokerWorker(ProcessInvokerTest invokerTest) {
        processInvokerTest = invokerTest;
    }

    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Runnable#run()
     */
    public void run() {
        if (processInvokerTest != null) {
            try {
                processInvokerTest.testInvokeProcess();
            } catch (Exception e) {
                Logger logger = Logger.getLogger(processInvokerTest.getClass());
                logger.error("Exception while executing ProcessInvokerTest.testInvokeProcess(): "+e.getMessage(), e);
            }
        }
    }
}
