/*
 * Copyright (c) 2008, PRODYNA AG, Germany. All rights reserved. Created 09.01.2008
 */

package classcastexceptiontest.processinvoker;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

import classcastexceptiontest.jndi.JndiLookupUtil;
import classcastexceptiontest.process.ResponseMsg;
import classcastexceptiontest.processinvoker.ProcessInvoker;
import classcastexceptiontest.processinvoker.ProcessInvokerBinding;

/**
 * ProcessInvoker2Test
 * 
 * @author Andreas Heizenreder (PRODYNA AG)
 * @version $Id: ProcessInvoker2Test.java,v 1.1 2008/08/22 15:27:08 aheizenreder Exp $
 */
public class ProcessInvoker2Test implements ProcessInvokerTest {

    private String jndiProviderUrl = null;

    private Logger logger = Logger.getLogger(ProcessInvoker2Test.class);

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BasicConfigurator.configure();
    }

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    /**
     * Test method for {@link classcastexceptiontest.processinvoker.ProcessInvoker2#invokeProcess()}.
     */
    @Test
    public void testInvokeProcess() throws Exception {
        logger.debug("START testInvokeProcess() ...");
        // boolean running = true;
        ResponseMsg rs = null;
        ProcessInvoker processInvoker = null;

        jndiProviderUrl = JndiLookupUtil
                .readJndiProviderUrlProperty(JNDI_PROVIDER_URL_PROPERTY_NAME);
        if (jndiProviderUrl == null) {
            throw new Exception("No url for jndi lookup found");
        }

        processInvoker = JndiLookupUtil.getEJB(processInvoker, jndiProviderUrl,
                ProcessInvokerBinding.JNDI_BINDING_PROCESSINVOKER2);
        if (null == processInvoker) {
            throw new Exception("No ProcessInvoker2 found!");
        }

        try {
            rs = processInvoker.invokeProcess();
            Assert.assertNotNull("A response message is expected!", rs);
            logger.debug("Process response:\n" + rs.getResponseData());
        } catch (Throwable t) {
            logger.error("Error while calling invokeProcess: " + t.getMessage(), t);
        }

        logger.debug("END testInvokeProcess()");
    }

}
