/*
 * Copyright (c) 2008, PRODYNA AG, Germany. All rights reserved. Created 10.01.2008
 */

package classcastexceptiontest.processinvoker;

import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * ConcurrentProcessInvoke
 * 
 * @author Andreas Heizenreder (PRODYNA AG)
 * @version $Id: ConcurrentProcessInvoke.java,v 1.1 2008/08/22 15:27:08 aheizenreder Exp $
 */
public class ConcurrentProcessInvoke {

    private Logger logger = Logger.getLogger(ConcurrentProcessInvoke.class);

    /**
     * @throws java.lang.Exception
     */
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        BasicConfigurator.configure();
    }

    /**
     * @throws java.lang.Exception
     */
    @Before
    public void setUp() throws Exception {
    }

    /**
     * @throws java.lang.Exception
     */
    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void concurrentProcessInvoke() {
        logger.debug("START concurrentProcessInvoke() ...");
        ProcessInvoker1Test processInvokerTest1 = new ProcessInvoker1Test();
        ProcessInvoker2Test processInvokerTest2 = new ProcessInvoker2Test();

        ProcessInvokerWorker worker1 = new ProcessInvokerWorker(processInvokerTest1);
        ProcessInvokerWorker worker2 = new ProcessInvokerWorker(processInvokerTest2);

        Thread processInvokerThread1 = new Thread(worker1, "ProcessInvoker1");
        Thread processInvokerThread2 = new Thread(worker2, "ProcessInvoker2");

        processInvokerThread1.start();
        processInvokerThread2.start();

        try {
            processInvokerThread1.join();
        } catch (InterruptedException e) {
            logger.info("Waiting for ProcessInvoker1 interupted!");
        }

        try {
            processInvokerThread2.join();
        } catch (InterruptedException e) {
            logger.info("Waiting for ProcessInvoker2 interrupted!");
        }
        
        logger.debug("END concurrentProcessInvoke()");
    }
}
