/*
 * Copyright (c) 2008, PRODYNA AG, Germany. All rights reserved. Created 08.01.2008
 */

package classcastexceptiontest.processinvoker;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.naming.NamingException;

import org.apache.log4j.Logger;
import org.jboss.annotation.ejb.RemoteBinding;

import classcastexceptiontest.jndi.JndiLookupUtil;
import classcastexceptiontest.process.Process;
import classcastexceptiontest.process.ProcessBinding;
import classcastexceptiontest.process.RequestMsg;
import classcastexceptiontest.process.ResponseMsg;


/**
 * ProcessInvoker2
 * 
 * @author Andreas Heizenreder (PRODYNA AG)
 * @version $Id: ProcessInvoker2.java,v 1.1 2008/08/22 15:27:08 aheizenreder Exp $
 */
@Stateless
@Remote(ProcessInvoker.class)
@RemoteBinding(jndiBinding = ProcessInvokerBinding.JNDI_BINDING_PROCESSINVOKER2)
public class ProcessInvoker2 implements ProcessInvoker {

    private Logger logger = Logger.getLogger(ProcessInvoker2.class);

    private String jndiProviderUrl = null;

    public ResponseMsg invokeProcess() throws Exception {

        // get Process proxy
        Process process = null;
        if (jndiProviderUrl == null) {
            jndiProviderUrl = JndiLookupUtil.readJndiProviderUrlProperty(JNDI_PROVIDER_URL_PROPERTY_NAME);
            if (jndiProviderUrl == null) {
                throw new Exception("No url for jndi lookup found");
            }
        }

        try {
            process = JndiLookupUtil.getEJB(process, jndiProviderUrl, ProcessBinding.JNDI_BINDING_PROCESS);
        } catch (NamingException ne) {
            throw new Exception(ne);
        }
        if (null == process) {
            logger.error("Lookup for process failed!");
            throw new Exception("Lookup for process failed");
        }
        RequestMsg rq = new RequestMsg();
        rq.setRequestData("ProcessInvoker2");

        // invoke process
        ResponseMsg rs = process.doProcess(rq);

        return rs;
    }

}
