/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations.reflection;

import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityListeners;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.TableGenerator;
import org.dom4j.Element;
import org.hibernate.annotations.common.reflection.AnnotationReader;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.cfg.annotations.reflection.EJB3OverridenAnnotationReader;
import org.hibernate.cfg.annotations.reflection.XMLContext;
import org.hibernate.util.ReflectHelper;

public class EJB3ReflectionManager
extends JavaReflectionManager {
    private XMLContext xmlContext = new XMLContext();
    private HashMap defaults = null;

    public AnnotationReader buildAnnotationReader(AnnotatedElement annotatedElement) {
        if (this.xmlContext.hasContext()) {
            return new EJB3OverridenAnnotationReader(annotatedElement, this.xmlContext);
        }
        return super.buildAnnotationReader(annotatedElement);
    }

    public Map getDefaults() {
        if (this.defaults == null) {
            this.defaults = new HashMap();
            XMLContext.Default xmlDefaults = this.xmlContext.getDefault(null);
            ArrayList<Class> entityListeners = new ArrayList<Class>();
            for (String className : this.xmlContext.getDefaultEntityListeners()) {
                try {
                    entityListeners.add(ReflectHelper.classForName(className, ((Object)((Object)this)).getClass()));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Default entity listener class not found: " + className);
                }
            }
            this.defaults.put(EntityListeners.class, entityListeners);
            for (Element element : this.xmlContext.getAllDocuments()) {
                List elements = element.elements("sequence-generator");
                ArrayList<SequenceGenerator> sequenceGenerators = (ArrayList<SequenceGenerator>)this.defaults.get(SequenceGenerator.class);
                if (sequenceGenerators == null) {
                    sequenceGenerators = new ArrayList<SequenceGenerator>();
                    this.defaults.put(SequenceGenerator.class, sequenceGenerators);
                }
                for (Element subelement : elements) {
                    sequenceGenerators.add(EJB3OverridenAnnotationReader.buildSequenceGeneratorAnnotation(subelement));
                }
                elements = element.elements("table-generator");
                ArrayList<TableGenerator> tableGenerators = (ArrayList<TableGenerator>)this.defaults.get(TableGenerator.class);
                if (tableGenerators == null) {
                    tableGenerators = new ArrayList<TableGenerator>();
                    this.defaults.put(TableGenerator.class, tableGenerators);
                }
                for (Element subelement : elements) {
                    tableGenerators.add(EJB3OverridenAnnotationReader.buildTableGeneratorAnnotation(subelement, xmlDefaults));
                }
                ArrayList namedQueries = (ArrayList)this.defaults.get(NamedQuery.class);
                if (namedQueries == null) {
                    namedQueries = new ArrayList();
                    this.defaults.put(NamedQuery.class, namedQueries);
                }
                List currentNamedQueries = EJB3OverridenAnnotationReader.buildNamedQueries(element, false, xmlDefaults);
                namedQueries.addAll(currentNamedQueries);
                ArrayList namedNativeQueries = (ArrayList)this.defaults.get(NamedNativeQuery.class);
                if (namedNativeQueries == null) {
                    namedNativeQueries = new ArrayList();
                    this.defaults.put(NamedNativeQuery.class, namedNativeQueries);
                }
                List currentNamedNativeQueries = EJB3OverridenAnnotationReader.buildNamedQueries(element, true, xmlDefaults);
                namedNativeQueries.addAll(currentNamedNativeQueries);
                ArrayList<SqlResultSetMapping> sqlResultSetMappings = (ArrayList<SqlResultSetMapping>)this.defaults.get(SqlResultSetMapping.class);
                if (sqlResultSetMappings == null) {
                    sqlResultSetMappings = new ArrayList<SqlResultSetMapping>();
                    this.defaults.put(SqlResultSetMapping.class, sqlResultSetMappings);
                }
                List<SqlResultSetMapping> currentSqlResultSetMappings = EJB3OverridenAnnotationReader.buildSqlResultsetMappings(element, xmlDefaults);
                sqlResultSetMappings.addAll(currentSqlResultSetMappings);
            }
        }
        return this.defaults;
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }
}

